#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Provides: check_cpu

import json
import subprocess
import time


def die(status, message):
    print 'PASSIVE-CHECK:check_cpu;{};{}'.format(status, message)
    raise SystemExit(0)


def run_hw_watcher():
    """
    Runs hw_watcher and parses output:
    {
        "status": "OK",
        "timestamp": 1501081498.595991,
        "reason": [],
        "socket": null
    }
    """
    cmd = ['/usr/sbin/hw_watcher', 'cpu', 'extended_status']
    try:
        output = subprocess.check_output(cmd)
        d = json.loads(output)
        rv = {
            'status': d['status'],
            'timestamp': d['timestamp'],
            'reason': d['reason'],
            'socket': d['socket']
        }
    except Exception as e:
        rv = {"status": "WARN", "timestamp": time.time(), "reason": e, "socket": None}
    return rv


def parse_output(out):
    status = 0
    message = 'Ok'
    if not out['status'] == 'OK':
        status = 1
        message = 'status: {}; reason: {}; socket: {}'.format(
            out['status'], out['reason'], out['socket'])
    return status, message


def main():
    out = run_hw_watcher()
    status, message = parse_output(out)
    die(status, message)


if __name__ == '__main__':
    main()
