#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Provides: check_dstate_count

import subprocess
from collections import defaultdict

provide = 'check_dstate_count'

def die(code, msg):
    print("PASSIVE-CHECK:{};{};{}".format(provide, code, msg))
    raise SystemExit(0)

def main():
    result = defaultdict(int)
    try:
        ps_out = subprocess.check_output(('ps', '-e', '-o', 'state,cgroup'))
    except Exception as e:
        die(1, "Failed to get process stats {}".format(str(e)))
    for ps_str in ps_out.strip().split('\n'):
        state, cgroup = ps_str.split(None, 1)
        if state != 'D':
            continue
        if not '/porto%' in cgroup:
            result['system'] += 1
        else:
            result[cgroup] += 1
    # if d-states in system (without processes in porto) more than 100
    if result.get('system', 0) > 100:
        die(2, "Host have more than 100 processes in D state")
    # if the number of containers with d-states > 10 and total number of d-states more than 100
    elif len(result) > 10 and sum(result.values()) > 100:
        die(2, "Host have more than 10 containers with processes in D state")
    else:
        die(0, "OK")
    return result

if __name__ == '__main__':
    main()
