#!/bin/sh

# Provides: rotmissingdocs

#
# state file format:
# TIMESTAMP=1553252962
# STAT=0.00;0.00;0.00;0;2772  #WallClockTime;UserTime;SysTime;AvgTotalMem(KiB);MaxRSS(KB)
# EXITCODE=2


METRIC='rotmissingdocs'
PATH='/tmp'
SERVICE='rotmissingdocs'
STATEFILE='ROTATE.STATE'
MAXGAP=600

SEND_STAT=  # 1 - true, empty - false

CURRTIME=$(/bin/date '+%s')
MSG=''
ERRLVL=0
LOG=''

TIMESTAMP=0
STAT=''
EXITCODE=127

die () {
        err_c="$1"
        shift
        echo "PASSIVE-CHECK:${METRIC};$err_c;$*"
        exit 0
}

file="${PATH}/${STATEFILE}"
if [ -r "${file}" -a -f  "${file}" ]; then
  . "${file}"
  DIFF=$(/usr/bin/expr "${CURRTIME}" - "${TIMESTAMP}")
  if [ $DIFF -gt $MAXGAP ]; then
    die 2 'Task been running too long ago'
  fi

  if [ $EXITCODE -eq 0 ];then
    ERRLVL=0
    MSG="Task ${SERVICE}: OK"
  else
    ERRLVL=2
    MSG="Task ${SERVICE}: Failed, Exit code: ${EXITCODE}"
  fi

  if [ ${SEND_STAT} ]; then
    die ${ERRLVL} ${MSG} "Stat: ${STAT}"
  else
    die ${ERRLVL} ${MSG}
  fi

else
  die 1 "No state file or file inaccessible"
fi
