import json
import subprocess
import sys
import time


def die(check_name, status, message):
    timestamp = time.time()
    result = json.dumps({"status": status, "timestamp": int(timestamp), "reason": message})
    print('PASSIVE-CHECK:%s;%s;%s' % (check_name, status, result))
    sys.exit(0)


def check_faulty_services(section):
    check_name = 'check_' + section + '_procs'
    state_filename = '/dev/shm/' + check_name + '.json'

    raw_state = ''
    try:
        raw_state = subprocess.check_output(["skyctl", "check", "-f", "json", section])
    except subprocess.CalledProcessError as e:
        if e.returncode == 4:  # workaround, SKYDEV-1549
            raw_state = e.output
        else:
            die(check_name, 2, "Failed to get skynet state (%s)" % e)
    except Exception as e:
        die(check_name, 2, "Failed to run skyctl (%s)" % e)

    new_state = json.loads(raw_state)

    if not new_state:
        die(check_name, 2, "State is empty")

    try:
        with open(state_filename) as f:
            old_state = json.load(f)
    except Exception:
        old_state = new_state

    try:
        with open(state_filename, "w") as f:
            f.write(raw_state)
    except Exception as e:
        die(check_name, 2, "Failed to save skynet state (%s)" % e)

    errs = []

    for service, info in new_state[section].items():
        # https://wiki.yandex-team.ru/skynet/skycore/#vozmozhnyesostojanija
        if info['state'] in ['RUNNING', 'PRERUNNING', 'PREFAIL']:
            continue

        if section in old_state and service in old_state[section]:
            if old_state[section][service]['state'] in ['RUNNING', 'PRERUNNING', 'PREFAIL']:
                continue

        errs.append(service)

    if errs:
        die(check_name, 2, ','.join(sorted(errs)) + ' in error state.')

    die(check_name, 0, 'OK')
