#!/bin/sh

# Provides: dns64_localcacher

METRIC='dns64_localcacher'
RESOLVER='fd64::1'
#RESOLVER='2a02:6b8:0:3400::5005'
TESTNAME='github.com'

die () {
        err_c="$1"
        shift
        echo "PASSIVE-CHECK:$METRIC;$err_c;{\"timestamp\": $(date +%s 2>/dev/null), \"reason\": \"$(echo $* | sed s/\"/\\\\\"/g)\"}"
        exit 0
}

hostresp=$(host -W 2 ${TESTNAME} ${RESOLVER} 2>&1)
hostrc=$?
if [ $hostrc -ne 0 ]
  then
    die 2 'Resolve unsuccessfull'
  else
    IPv6CNT=$(echo ${hostresp} | grep -c 'IPv6')
    if [ ${IPv6CNT} -eq 0 ]
      then
        die 2 'No IPv6 addresses returned'
      else
        die 0 'DNS64 OK'
    fi
fi
