#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Provides: fb_route_check

import os
import sys
import re
import time
import json
import subprocess
import socket

check_name="fb_route_check"
exclude_vlans = ['vlan1478', 'vlan711', 'vlan1496']
check_host = 'fb-jnob-juggler.yandex.ru'


def die(check_name, status, message):
    print 'PASSIVE-CHECK:%s;%s;%s' % (check_name, status, message)
    sys.exit(0)


def fb_eth_list():
    eth_li = []
    all_eth = os.listdir('/sys/class/net/')
    for eth in all_eth:
        if eth in exclude_vlans:
            continue
        if eth.startswith('L3'):
            continue
        with open('/sys/class/net/' + eth + '/operstate') as f:
            status = f.read()
            status = status.strip()
        if status == 'up':
            group = 0
            with open('/sys/class/net/' + eth + '/netdev_group') as fc:
                group = int(fc.read())
            if group == 2:
                eth_li.append(eth)
    return eth_li


def get_all_ip():
    ips = []
    local_ips = []
    try:
        with open('/etc/server_info.json') as f:
            all_info = json.loads(f.read())
            local_ips = all_info['ipv6']
    except:
        pass

    res = socket.getaddrinfo('fb-jnob-juggler.search.yandex.net', None, socket.AF_INET6)
    for r in res:
        if r[4][0] not in local_ips:
            ips.append(r[4][0])
    return ips


def check_route(ip, fb_vlans):
    cmd = 'ip route get {}'.format(ip)
    try:
        info = subprocess.check_output(cmd.split())
    except:
        return False

    line1 = info.split('\n')[0]
    line_split = line1.split()
    if line_split[3] == 'via':
        dev = line_split[6]
    else:
        dev = line_split[4]
    # print(dev, fb_vlans)
    if dev in fb_vlans:
        return True
    else:
        return False


if __name__ == '__main__':
    fb_vlans = fb_eth_list()
    ips = get_all_ip()
    msg = ""
    for ip in ips:
        if not check_route(ip, fb_vlans):
            msg += '{} has wrong route;'.format(ip)
    if msg != "":
        die(check_name, 2, msg)
    else:
        die(check_name, 0, "Ok")

