#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Provides: fs_mount_opts

# $Id$
# $HeadURL$

# https://st.yandex-team.ru/RUNTIMECLOUD-7757

DEFAULT_OPTS = {
    'forbidden': [ 'nobarrier', 'ro' ],
    'mandatory': [ 'lazytime', 'noatime', 'nodev', 'nosuid' ],
}

MOUNT_POINTS = {
    '/': {
        'forbidden': [ 'nobarrier', 'ro' ],
        'mandatory': [ 'lazytime', 'noatime' ],
    },
    '/home': DEFAULT_OPTS,
    '/place': DEFAULT_OPTS,
    '/ssd': DEFAULT_OPTS,
}


def die(status, message):
    print('PASSIVE-CHECK:fs_mount_opts;{};{}'.format(status, message))
    raise SystemExit(0)


def check(check_opts):
    errors = []

    try:
        with open('/proc/mounts') as f:
            for line in f:
                _, mpoint, fstype, mopts = line.split()[:4]

                if fstype != 'ext4':
                    continue

                if mpoint not in check_opts:
                    continue

                mopts = mopts.split(',')
                forbidden = []
                mandatory = []

                for opt in check_opts[mpoint]['forbidden']:
                    if opt in mopts:
                        forbidden.append(opt)

                for opt in check_opts[mpoint]['mandatory']:
                    if opt not in mopts:
                        mandatory.append(opt)

                if forbidden:
                    forbidden = ','.join(forbidden)
                    errors.append(mpoint + ' has forbidden opts: ' + forbidden)

                if mandatory:
                    mandatory = ','.join(mandatory)
                    errors.append(mpoint + ' has no mandatory opts: ' + mandatory)

    except Exception as e:
        die(2, str(e))

    return errors


if __name__ == '__main__':
    errors = check(MOUNT_POINTS)

    if errors:
        die(2, '; '.join(errors))

    die(0, 'Ok')

