#!/usr/bin/env python
# -*- coding: utf-8 -*-
# copy from load_monitor.py
# Provides: io_monitor


import os
import time
import sys

fs_red = 90
fs_yellow = 80
io_red = 30
db_red = 50

waittime = 2


def die(n, s):
    print("PASSIVE-CHECK:%s;%d;%s" %(sys.argv[0].split('/')[-1].split('.')[0], n, s))
    exit(0)


def _disk_stat():
    global DISK
    try:
        f = open("/proc/diskstats", "r")
        for i in f:
            a = i.split()
            if a[2][0:2] == "sd" and len(a[2]) == 3:
                DISK[a[2]] = {"reads":int(a[3]), "r_ms":int(a[6]), "writes":int(a[7]), "w_ms":int(a[10]), "svctm": int(a[12])}
        f.close()
    except IOError:
        die(2, "No diskstats file")


if __name__ == '__main__':
    err = 0
    msg = ""
    DISK = {}
    v = True if len(sys.argv) > 1 and sys.argv[1] == "-v" else False

    _disk_stat()
    DISK1 = {i:DISK[i].copy() for i in DISK}
    time.sleep(waittime)
    _disk_stat()

    for i in DISK:
        # % of time average r/w request is taking
        sum = 0
        r = DISK[i]["reads"] - DISK1[i]["reads"]
        r_req = r
        sum += r
        r = float(DISK[i]["r_ms"] - DISK1[i]["r_ms"])/r if r > 0 else 0
        w = DISK[i]["writes"] - DISK1[i]["writes"]
        sum += w
        w_req = w
        w = float(DISK[i]["w_ms"] - DISK1[i]["w_ms"])/w if w > 0 else 0
        if r_req > 0 and w_req > 0:
            svctm = float(DISK[i]["svctm"] - DISK1[i]["svctm"]) / (r_req + w_req)
        elif r > 0:
            svctm = float(DISK[i]["svctm"] - DISK1[i]["svctm"]) / r_req
        elif w > 0:
            svctm = float(DISK[i]["svctm"] - DISK1[i]["svctm"]) / w_req
        else:
            svctm  = float(DISK[i]["svctm"] - DISK1[i]["svctm"])
        #  = float(DISK[i]["svctm"] - DISK1[i]["svctm"]) if w > 50 else 0

        # if r > db_red or w > db_red or svctm >= 20 or v:
        if ( svctm >= 20 and svctm <= 150 ) or v:
            err = 1
            # msg += "|%s:svctm=%s" % (i, svctm)
            msg += "|%s:r/w=%.2f/%.2fms; svctm=%s" % (i, r, w, svctm)
        elif svctm > 150:
            err = 2
            # msg += "|%s:svctm=%s" % (i, svctm)
            msg += "|%s:r/w=%.2f/%.2fms; svctm=%s" % (i, r, w, svctm)

    if err == 0 and not v:
        msg = "|Ok"
    elif v:
        err = 0
    die(err, msg[1:])
