#!/bin/bash
#
# Provides: ip_groups

me=$(basename "${0}")

die() {
	echo "PASSIVE-CHECK:${me%.*};$1;$2"
	exit 0
}

check_file() {
    if [ ! -e /etc/iproute2/group ]; then
        die 1 "Can't find /etc/iproute2/group"
    fi
       
    if ! grep -qs fastbone /etc/iproute2/group;then
        die 1 "Can't find fastbone in /etc/iproute2/group"
    fi
}


check_groups() {
    if [ `ip address show group backbone  | wc -l` -eq 0 ];then
        die 2 "Can't find interfases marked as backbone"
    fi

    if [ `ip address show group fastbone  | wc -l` -eq 0 ];then 
        die 2 "Can't find interfases marked as fastbone"
    fi
}

check_file
check_groups

die 0 "Ok"
