#!/bin/sh
#
# Check for highload link utilization
#
# Provides: link_utilization

me=${0##*/}     # strip path
me=${me%.*}     # strip extension

BASE=$HOME/agents
CONF=$BASE/etc/$me.conf
TMP=$BASE/tmp
PATH=/bin:/sbin:/usr/bin:/usr/sbin

die () {
        echo "PASSIVE-CHECK:$me;$1;$2"
        exit 0
}

link_speed_precision="5"
link_speed_threshold_percentage="90"

[ -s $CONF ] && . $CONF

link_names=$(ls /sys/class/net/|grep eth)

link_utilization() {

link_speed=$(cat /sys/class/net/${1}/speed 2>/dev/null)

case $link_speed in
    "4294967295"|"65535"|""|"-1")
        continue
    ;;
    "1000"|"10000"|"25000"|"50000"|"100000")
        link_speed_th=$(( $link_speed * $link_speed_threshold_percentage / 100 ))
    ;;
    *)
        die 2 "Wrong link speed: ${link_speed}"
    ;;
esac

link_speed_diff_cur_tx=$(cat /sys/class/net/${1}/statistics/tx_bytes && \
                     sleep ${link_speed_precision} && \
                     cat /sys/class/net/${1}/statistics/tx_bytes)
link_speed_diff_cur_rx=$(cat /sys/class/net/${1}/statistics/rx_bytes && \
                     sleep ${link_speed_precision} && \
                     cat /sys/class/net/${1}/statistics/rx_bytes)
link_speed_tx=$(echo ${link_speed_diff_cur_tx} | awk -v p=${link_speed_precision} \
                  's=$2-$1 {if (s == "0") {print s}} {print int(s/1024/1024/p*8)}')
link_speed_rx=$(echo ${link_speed_diff_cur_rx} | awk -v p=${link_speed_precision} \
                  's=$2-$1 {if (s == "0") {print s}} {print int(s/1024/1024/p*8)}')

if [ "$link_speed_tx" -ge "$link_speed_th" ] || [ "$link_speed_rx" -ge "$link_speed_th" ]; then
    die 2 "High Load: tx:${link_speed_tx}Mbit/s, rx:${link_speed_rx}Mbit/s"
fi

}

for device in $link_names; do
    link_utilization $device
done

die 0 "Ok"

