#!/usr/bin/env python
# Provides: net_errors
# -*- coding: utf-8 -*-

# $Id$
# $HeadURL$

import os
import json

name = 'net_errors'
state_file = '/dev/shm/net_errors_state'


def die(name, status, msg):
    print("PASSIVE-CHECK:%s;%s;%s" % (name, status, msg))
    raise SystemExit(0)


def eth_list():
    eth_li = []
    all_eth = os.listdir('/sys/class/net/')
    for eth in all_eth:
        if eth.startswith('L3'):
            continue
        if eth.startswith('tap'):
            continue
        if eth.startswith('veth'):
            continue
        with open('/sys/class/net/' + eth + '/operstate') as f:
            if f.read().strip() == 'up':
                eth_li.append(eth)
    return eth_li


def check_errors(interface):
    with open('/proc/net/dev_snmp6/{}'.format(interface)) as f:
        res = f.read()
    errors = {
            'Ip6InHdrErrors': 0,
            'Ip6InTooBigErrors': 0,
            'Ip6InAddrErrors': 0,
            'Ip6InDiscards': 0,
            'Ip6OutDiscards': 0,
            'Icmp6InErrors': 0,
            'Icmp6OutErrors': 0,
            'Icmp6InCsumErrors': 0,
            'Udp6InErrors': 0,
            'Udp6RcvbufErrors': 0,
            'Udp6SndbufErrors': 0,
            'Udp6InCsumErrors': 0,
            'UdpLite6InErrors': 0,
            'UdpLite6RcvbufErrors': 0,
            'UdpLite6SndbufErrors': 0,
            'UdpLite6InCsumErrors': 0,
            'Ip6ReasmFails': 0,
            'Ip6FragFails': 0,
#             'Icmp6InDestUnreachs': 0,
#             'Icmp6OutDestUnreachs': 0
            }
    for line in res.split('\n'):
        line = line.strip()
        if line == "":
            continue
        name, count = line.split()
        if name in errors:
            errors[name] = int(count)
    state_prev = {}
    if os.path.exists(state_file + '_' + interface):
        with open(state_file + '_' + interface, 'r') as f:
            try:
                state_prev = json.load(f)
            except ValueError:
                pass
    msg = ""
    if state_prev != {}:
        for name, couter in state_prev.items():
            # Do not count Ip6FragFails on fastbone. See: RUNTIMECLOUD-6350 for details.
            if interface in ['vlan788', 'vlan688'] and name == 'Ip6FragFails':
                continue
            if errors[name] - state_prev[name] >= 10 :
                msg += "counter {} {} changed (current:{} changed more than 10: {});".format(
                        name,
                        interface,
                        errors[name],
                        errors[name]-state_prev[name])
    try:
        with open(state_file + '_' + interface, 'w') as f:
            json.dump(errors, f)
    except Exception as e:
        die(name, 2, "Failed to save state (%s)" % e)

    return msg


if __name__ == '__main__':
    devices = eth_list()
    msg = ""
    for dev in devices:
        res = check_errors(dev)
        if res != "":
            msg += res
    if msg != "":
        die(name, 2, msg)
    else:
        die(name, 0, "Ok")

