#!/usr/bin/python
# -*- coding: utf-8 -*-
# Provides: numa_memory

import os
import sys


def die(exit_num, exit_str):
    print "PASSIVE-CHECK:numa_memory;%d;%s" % (exit_num, exit_str)
    sys.exit(0)


def read_counter(node):
    try:
        with open('/sys/devices/system/node/node{}/meminfo'.format(node)) as f:
            line = f.readline()
            counter = line.split()[-2]
            return float(counter)
    except Exception as e:
        die(1, str(e))


def main():
    info = {0:0, 1: 0}
    for i in (0,1):
        info[i] = read_counter(i)

    if info[0] == 0 or info[1] == 0:
        die(1, "some of numa node have zero memory: {}".format(info))

    if info[0] / info[1] < 0.9 or info[0] / info[1] > 1.1:
        die(1, "numa nodes have different memory count: {}".format(info))

    die(0, "Ok")


if __name__ == '__main__':
    main()
