#!/bin/sh
#
# Provides: packages_state
#
# Description: this script check, that packages state correct on a host.
#  Now only dpkg supported.
#
# Author: komnac@yandex-team.ru
#

ME=${0##*/}
ME=${ME%.*}

[ -w "/dev/shm" ] && states_path="/dev/shm"
: ${states_path="${HOME}/agents/tmp"} # empty -- disable

PREV_STATE=$states_path/${ME}.prev

PATH=/bin:/sbin:/usr/bin:/usr/sbin:${PATH}

die()
{
	local _msg _lvl
	_lvl=${1:-0}
	_msg=${2:-"ok"}

	echo "PASSIVE-CHECK:${ME};${_lvl};${_msg}" | tee ${PREV_STATE}

	exit 0
}

show_prev()
{
	if [ ! -s ${PREV_STATE} ]; then
		die 0 "Unknown packages state"
	fi

	cat ${PREV_STATE}

	exit 0
}

has_broken_packages()
{
	$DPKG_CMD -l 2> /dev/null | grep -E -q -e '^\S*[A-Z]\S*\s'
}

is_dpkg_locked()
{
	sudo lsof /var/lib/dpkg/lock 2>&1 | grep -E -e '^(dpkg|apt)' |\
		grep -E -q -e '^\S+\s+\S+\s+\S+\s+\S*W\S*\s'
}

get_broken_packages()
{
	local _packages=''
	local _status
	local _name
	local _other
	$DPKG_CMD -l 2> /dev/null | grep -E -e '^\S*[A-Z]\S*\s' | while read _status _name _other ; do
		echo "${_name}($(get_package_status ${_status}))"
	done
}

get_package_status()
{
	local _status=${1:-''}
	local _full_status
	_status=$(echo ${_status} | sed 's/[a-z]//g')
	if [ -z ${_status} ] ; then
		echo "good"
		return 
	fi

	_full_status=''
	for letter in $(echo ${_status} | sed 's/\([A-Z]\)/\1 /g') ; do
		case $letter in
			'H') _full_status="${_full_status},half-installed"
			;;
			'U') _full_status="${_full_status},unpacked"
			;;
			'F') _full_status="${_full_status},half-configured"
			;;
			'W') _full_status="${_full_status},triggers-awaiting"
			;;
			'R') _full_status="${_full_status},reinst-required"
			;;
		esac
	done
	_full_status=${_full_status#,}
	echo $_full_status
}

DPKG_CMD=$(which dpkg) || die 0 "None dpkg util"

if is_dpkg_locked ; then
	show_prev
fi

if has_broken_packages ; then
	broken_packages=$(get_broken_packages | tr "\n" ",")
	die 2 "Broken packages: ${broken_packages%,}"
fi

die 0

