#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Provides: raid_state

# $Id$
# $HeadURL$

import json
import os


STATE_FILE = '/dev/shm/raid_state.json'


def die(exit_num, exit_str):
    print "PASSIVE-CHECK:raid_state;%d;%s" % (exit_num, exit_str)
    raise SystemExit(0)


def main():
    try:
        with open(STATE_FILE) as f:
            old_state = json.load(f)
    except Exception:
        old_state = {}

    new_state = {}
    stalled_raids = []

    for md in os.listdir('/sys/devices/virtual/block/'):
        try:
            with open('/sys/devices/virtual/block/' + md + '/md/level') as f:
                if f.read().strip() not in {'raid1', 'raid10'}:
                    continue
        except IOError:  # not a MD device (No such file)
            continue

        new_state[md] = {}

        with open('/sys/devices/virtual/block/' + md + '/md/sync_action') as f:
            new_state[md]['state'] = f.read().strip()
        with open('/sys/devices/virtual/block/' + md + '/md/sync_completed') as f:
            new_state[md]['sync_completed'] = f.read().strip()

        if new_state[md]['state'] != 'resync':
            continue
        if new_state[md]['sync_completed'] == 'delayed':
            continue

        if md in old_state:
            # sync_completed shows the number of sectors as 'complete/total';
            # this means sync stalled if this value not changed since last run.
            if new_state[md]['sync_completed'] == old_state[md]['sync_completed']:
                stalled_raids.append(md)

    try:
        with open(STATE_FILE, 'w') as f:
            json.dump(new_state, f)
    except Exception as e:
        die(2, 'failed to save state file: {}'.format(e))

    if stalled_raids:
        die(1, "sync stalled for " + ','.join(stalled_raids))

    die(0, "Ok")


if __name__ == '__main__':
    main()
