#!/usr/bin/env bash
#
# Provides: runtime_debsums

me="$(basename "$0")"
diff_time=86400
_str=""

die(){
    echo "PASSIVE-CHECK:${me%.*};$1;$2"
    exit
}

stat_file="/tmp/.debsums.state"

if [ -f $stat_file ]; then
    modify_time=$(stat -c %Y $stat_file)
    now=$(date +%s)
    if [ $(( $now - $modify_time )) -lt $diff_time ] ; then
        die "$(cat $stat_file)"
    fi
fi

die 0 "Ok"
