#!/bin/sh

# Provides: qloud_logoped_statforward

METRIC='qloud_logoped_statforward'
SERVICE='qloud-logoped-statforward-routers'

die () {
        err_c="$1"
        shift
        echo "PASSIVE-CHECK:$METRIC;$err_c;{\"timestamp\": $(date +%s 2>/dev/null), \"reason\": \"$(echo $* | sed s/\"/\\\\\"/g)\"}"
        exit 0
}

srvresp=$(service ${SERVICE} status 2>&1)
srvrc=$?

if [ $srvrc -ne 0 ]
  then
    die 2 'Service' ${SERVICE} 'failed:' ${srvresp}
  else
    die 0 'Service' ${SERVICE} 'OK'
fi
