#!/bin/sh
#
# Provides: skynet_copier
#
# $Id$
# $HeadURL$
#
# Try to share and to get file using skynet copier
# https://st.yandex-team.ru/SEPE-8119

PATH=/bin:/sbin:/usr/bin:/usr/local/bin

me=${0##*/}
me=${me%.*}

: ${DELAY_SHARE_CHECK_SECONDS="0"} #HOSTMAN-750

die () {
    echo "PASSIVE-CHECK:$me;$1;$2"
    exit 0
}

: ${workdir="/dev/shm"}
: ${timeout=57}
: ${kill_timeout=58}

[ "`id -un`" = "monitor" ] || \
    die 2 "Only user 'monitor' can run this script" 1 # to avoid perms issues, test files must be in one place

cd ${workdir} || die 2 "Failed to change cwd"

which sky >/dev/null || die 2 "Failed to locate sky util"

local="`hostname -f | md5sum | sed -E 's/^[a-f]*([0-9]).*/\1/'`"
local="$(($local % 2))" # 0 or 1 (which side we are belong to =)
remote=$(((${local} + 1) % 2))

file_tmpl="skynet_copier.test.SEPE-8119"
body_tmpl="https://st.yandex-team.ru/SEPE-8119"

errs=""

# try to fetch test file from other group of hosts
if [ ${local} = 0 ]; then
    rbtorrent="rbtorrent:2bf2cd1c7ea39249b73bb19beac1fe782c3b79aa"
else
    rbtorrent="rbtorrent:fc86cb5961cb8b459f974f3c467e4bbe88adda69"
fi

rm -f "${file_tmpl}.${remote}" || \
    die 2 "Failed to remove test file" # rm local copy; we must refetch it to check copier

timeout --kill-after=${kill_timeout} ${timeout} \
    sky get --opts='subproc: 1' -u -w -d . "${rbtorrent}" >/dev/null 2>&1 & # in background, RUNTIMECLOUD-6475

# share test file for other group of hosts
share_check_age=$((`date +%s` - `stat --format=%Y "${file_tmpl}.${local}" 2>/dev/null || echo 0`))

if [ ${share_check_age} -ge ${DELAY_SHARE_CHECK_SECONDS} ]; then
    if echo "${local} ${body_tmpl}" > "${file_tmpl}.${local}"; then
        timeout --kill-after=${kill_timeout} ${timeout} \
            sky share --opts='subproc: 1' -d . "${file_tmpl}.${local}" >/dev/null 2>&1 || \
            errs="Failed to share test file; $errs"
    else
        errs="Failed to write test file; $errs"
    fi
fi

wait # sky get process

[ "`cat "${file_tmpl}.${remote}" 2>&1`" = "${remote} ${body_tmpl}" ] || \
    errs="Failed to fetch test file; $errs"

[ -n "$errs" ] && die 2 "$errs"

die 0 "Ok"
