#!/bin/sh
#
# Provides: ssd_link
#
# $Id$
# $HeadURL$
#
# Alert if ssd disk connected via slow sata link (less than 6.0 Gbps)
# https://st.yandex-team.ru/RUNTIMECLOUD-6025

me=${0##*/}
me=${me%.*}

die () {
    echo "PASSIVE-CHECK:$me;$1;$2"
    exit 0
}

SLOW_RE='^INTEL SSDSA2BW30|INTEL SSDSA2BW60|INTEL SSDSA2CW30|INTEL SSDSA2CW60$'

errors=""
fast=""
slow="" # drives with 3.0 and lower Gbps interface by design

fast_links=1000
# There is only two 6.0 Gbps channels on old Sandy/Ivy Bridge platforms
grep -qE -m1 'CPU E5-26.. v?[0-2] @' /proc/cpuinfo && \
    fast_links=2

for sata_link in /sys/class/ata_link/*; do
    for block_dev in $sata_link/../../../host*/target*/*/block/*; do
        [ -d $block_dev ] || continue

        rotates=`cat $block_dev/queue/rotational`
        [ "$rotates" = "0" ] || continue

        speed=`cat $sata_link/sata_spd`
        if [ "$speed" != "6.0 Gbps" ]; then
            model=`cat $block_dev/device/model`

            udev_path="/run/udev/data/b`cat $block_dev/dev`"
            serial=`awk -F= '$1 == "E:ID_SERIAL_SHORT" {print $2}' $udev_path`

            info="$speed"

            if grep -qi error $sata_link/device/dev*/ata_device/dev*/ering; then
                info="$info, AtaLinkErrs"
            else
                if echo "$model" | grep -qE "$SLOW_RE"; then
                    slow="$model; $slow"
                    continue
                fi

                [ $fast_links -lt 1 ] && continue
            fi

            fast_links=$((fast_links - 1))
            errors="$model (sn:$serial) connected via slow ($info) link; $errors"
        fi

        fast=yep
    done
done

[ -n "$fast" -a -n "$slow" ] && \
    errors="${errors}Fast and slow connected SSD drives are mixed together."

[ -n "$errors" ] && die 1 "$errors"

die 0 "Ok"
