#!/usr/bin/env python
#
# Provides: tsolro_check
#
# $Id$
# $HeadURL$

import os
import sys
import subprocess


check_name='tsolro_check'

def die(check_name, status, message):
    print 'PASSIVE-CHECK:%s;%s;%s' % (check_name, status, message)
    sys.exit(0)


if __name__ == '__main__':
    msg = ""
    checks = {
        'tcp-segmentation-offload': 'off',
        'large-receive-offload': 'off'
    }

    for iface in os.listdir('/sys/class/net/'):
        if not iface.startswith('eth'):
            continue
        with open('/sys/class/net/' + iface + '/operstate') as f:
            if f.read().strip() != "up":
                continue

        with open(os.devnull, 'w') as devnull:
            info = subprocess.check_output(['ethtool', '--show-offload', iface], stderr=devnull)

        for line in info.splitlines()[1:]:  # skip header
            (name, status) = line.split(': ')
            if name in checks and status.split()[0] != checks[name]:
                msg += '{} on {} is {}(it should be {});'.format(name, iface, status, checks[name])

    if msg == '':
        die(check_name, 0, 'Ok')
    else:
        die(check_name, 2, msg)
