# -*- coding: utf-8 -*-
import os
import pytest

from infra.rtc.juggler.bundle.checks import create_manifest


@pytest.fixture
def manifest():
    return create_manifest()


@pytest.fixture
def os_stat_proxy():
    class StatProxy(object):
        """
        Return predefined stats for registered files; call real os.stat for the
        rest.

        """
        __fields = ('mode', 'ino', 'dev', 'nlink', 'uid', 'gid', 'size',
                    'atime', 'mtime', 'ctime')

        __defaults = {
            'mode': 33188,
            'ino': 1,
            'dev': 53,
            'nlink': 1,
            'uid': 0,
            'gid': 0,
            'size': 0,
            'atime': 0,
            'mtime': 0,
            'ctime': 0,
        }

        def __init__(self):
            self.mock = {}
            self.stat = os.stat  # save reference to original (not patched)
            self.stat_result = os.stat_result  # --"--

        def set(self, path, **result_kwargs):
            self.mock[path] = self.stat_result(
                result_kwargs.pop(_, self.__defaults[_]) for _ in self.__fields
            )

            if result_kwargs:
                raise TypeError('Unpupported kwargs: ' +
                                ', '.join(result_kwargs.keys()))

        def proxy(self, path):
            try:
                return self.mock[path]
            except KeyError:
                return self.stat(path)

    return StatProxy
