# RTC Hosts Monitoring Explained

**DISCLAIMER**  
Описываемое касается только событийного мониторинга физических хостов и базовых инфраструктурных сервисов.  
Продуктовые (взаимодействующие в внешними пользователями) сервисы и количественный мониторинг остаются за пределами
этого описания.

### Событийный мониторинг
1. Дает сигнал, что авария *случилась* (или скоро случится).
2. Показывает [*что*](https://www.youtube.com/watch?v=xoBnQg4_J60&feature=youtu.be&t=135) сломалось.
3. Помогает понимать *где* сломалось.

Цель очевидна: максимально быстро локализовывать и чинить возникающие проблемы.

### RTC не мониторит единичные хосты
Сигналы с хостов агрегируются. Каждый агрегат обрабатывает сигналы от единиц до десятков тысяч хостов.  
Именно про агрегаты и пойдет речь дальше.

### Зачем нужна структура агрегатов
- Мониторимые сущности имеют структуру (география, стейджи, подпроекты, подсистемы).
- Навигация: структура позволяет находить (спускаясь от общего к частному) агрегаты не зная точных атрибутов.
- Дает возможность оценить что покрыто мониторингом.
- Позволяет строить осмысленный дифф от версии к версии и контролировать внесение изменений.
- Структура дает понимание где и как используется агрегат и используется ли вообще.

### Почему у нас именно такая структура агрегатов
В RTC используется сквозная по-проверочная структура которая ветвится:
 * по ролям и регионам (для географически распределенных сущностей: RTC, QLOUD, YP...).
 * по проектам, если географического разделения нет (кластеры YT'я например).
 * Или не ветвится =) Отдельно агрегаты собираются для инфраструктурного престейбла (солянка из машин разных проектов).

[Такая структура](https://proxy.sandbox.yandex-team.ru/1708235818/RTC.hostman-salt.html) позволяет понять *что*
сломалось: какая подсистема и масштаб проблемы (стейдж, проект, регион, ...).  
Значит можно принимать более точные решения (если слег престейбл, то не катим дальше в прод и т.п.).

Естественно мониторится не только хостман. Такие же наборы агрегатов строятся и для остальных 81 проверок =)  
Ну... почти такие же... Например, структура GPU агрегатов
[выглядела иначе](https://proxy.sandbox.yandex-team.ru/1708235818/RTC.check_gpu.html), ведь далеко не каждая машина
несет с собой GPU карточки.  
Одинаковость структур основных проверок позволяет "посмотрев по сторонам" видеть аномалии на агрегатах той же сущности
в связанных подсистемах.

Собранные воедино, агрегаты образуют [лес](https://proxy.sandbox.yandex-team.ru/1658011303/full.html) (кликабельно,
деревья свернуты, чтобы не тормозил браузер)

### Все еще немного ~~хуже~~ сложнее.
Структура описанная выше не до конца описывает отношения между проверками.  
Есть еще [зависимости между проверками](https://docs.yandex-team.ru/juggler/aggregates/dependencies). Цель
зависимостей - подавлять срабатывание проверок, если условий для их выполнения недостаточно.  
Проще на примере: бессмысленно присылать алерт о недоступности `sshd` если недоступен сам хост.  
Поэтому практически все проверки в RTC имеют в зависимостях `UNREACHABLE`, а пассивные еще и
[bundle\_info](https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/juggler/bundle/checks/bundle_info/README.md)

### Зачем нам столько (82 на момент написания) проверок
Да, для каждой из 82 проверок строятся агрегаты по всем актуальным для нее регионам-стейджам-сущностям-проектам.

Но почему так много?  
Зачем строить агрегаты для `walle_cpu`, например, ведь машины где горит эта проверка валли чинит самостоятельно?

Тут лучше привести пример: если перегреется датацентр, то [wall-e](https://wiki.yandex-team.ru/wall-e/) не будет
чинить машины (у валли "выбьет пробки"). А человек глядя на эти агрегаты сможет понять, что проблема не в сервисе, а в
троттлинге, который произошел из-за перегрева.

Поэтому мы имеем два типа проверок. Первый тип - основные (на них настроены алерты), второй - вспомогательные (на них
алертов обычно нет). Вспомогательные проверки позволяют значительно сократить время на поиск причины аварии (нужно
проверять меньше гипотез) т.е. помогает ответить на вопрос *где* сломалось. Это напрямую влияет на время устранения
аварии, что напрямую влияет на деньги.

### Панели мониторинга
Описывая структуры агрегатов я сознательно отложил на потом отдельный вид ~~извращений~~ структур агрегатов - панели.
Juggler достаточно гибок в части переиспользования агрегатов и позволяет агрегировать в т.ч. любые существующие
агрегаты. Т.е. можно "в стороне" собирать отдельные структуры агрегатов с необходимой логикой и предоставлять их
дежурной смене в виде [панелей](https://juggler.yandex-team.ru/dashboards/rtc_marty/).  
Пример для [Бора](https://proxy.sandbox.yandex-team.ru/1708235818/yt_panel-bohr.html)

### Зачем событийный (Juggler) мониторинг, если есть количественный (YASM, Solomon).
Исторически количественный и событийный мониторинги в Яндексе развивались независимо друг от друга и для разных целей.
Системы количественного мониторинга могут служить источником сигналов для событийного (и это используется), но
заменить его в целом не могут (во всяком случае в данный момент). Причин много, основные: разные типы собираемых
сигналов, способ их сбора и группировки.

### The Four Golden Signals
Четыре золотых сигнала считаются best practice в мониторинге, поэтому стоит пояснить почему они почти не используются в
описываемой схеме.

`Latency`, `Traffic`, `Errors`, `Saturation` - отличные метрики для мониторинга продуктовых сервисов.  
Но они, практически всегда, неприменимы к мониторингу хостов.

Пример: время ответа `sshd` измерять почти бессмысленно - на хосте может жить `CPU` или `I/O` прожорливый сервис
(привет, YT!), т.е. сервис работает как надо: утилизирует железо по максимуму, у него все ок, но `sshd` будет
откликаться медленно.

То же касается `CPU`, `I/O` и сети - в отрыве от продуктового сервиса их утилизация не значит почти ничего.  
Для мониторинга хостов, из указанной четверки, почти всегда остается только Errors.

### Мониторинг это не продукт. Это процесс.
Мониторинг постоянно меняется. Меняется среда выполнения (железо, ось, сеть) и сервисы (их количество, структура и
размеры). Появляются новые регионы, стейджи. Меняются бизнес процессы, требования, договоренности, устраняются и
добавляются ошибки и т.д.

Мониторинг обязан подстраиваться под изменения в бизнес-логике (неактуальные данные мониторинга бессмысленны), а значит
мониторинг не может быть конечным продуктом, это всегда процесс.

### SEE ALSO
https://docs.yandex-team.ru/juggler/  
https://landing.google.com/sre/sre-book/chapters/monitoring-distributed-systems/  
https://www.digitalocean.com/community/tutorials/gathering-metrics-from-your-infrastructure-and-applications  
https://www.digitalocean.com/community/tutorials/an-introduction-to-metrics-monitoring-and-alerting  
https://www.datadoghq.com/blog/monitoring-101-collecting-data/  
