"""
Juggler checks builder for RTC infra prestable cluster.
https://st.yandex-team.ru/RUNTIMECLOUD-9096

"""
from infra.reconf_juggler.builders import JugglerChecksBuilder

from infra.rtc.juggler.reconf.checksets import GpuCheckSet, RtcCheckSetPrestable
from infra.rtc.juggler.reconf.optfactories import RtcOptFactory

ENDPOINT_PREFIX = 'WALLE%PROD@prj='


class CheckSet(RtcCheckSetPrestable):
    branches = RtcCheckSetPrestable.branches + GpuCheckSet.branches


class Builder(JugglerChecksBuilder):

    def build_initial_data(self, unused):
        self.resolved = self.resolver['walle']['projects'].resolve({
            'tags': ('rtc.stage-prestable',),
            'fields': ('id', 'tags'),
        })

        projects = {}
        self.shared = {'walle_tags': {}}

        for prj in self.resolved:
            projects[prj['id']] = ENDPOINT_PREFIX + prj['id']
            self.shared['walle_tags'][prj['id']] = prj['tags']

        return projects

    def build_initial_tree(self, initial_data):
        children = {}
        initial_tree = {'all_infra_prestable': {'children': children}}
        for child in initial_data.values():
            children[child] = None

        return initial_tree

    def build_checks_tree(self, initial_tree):
        return CheckSet(
            initial_tree,
            opt_factory=RtcOptFactory(),
            resolver=self.resolver,
            shared=self.shared,
        )


def main():
    Builder().run(app_desc=__doc__)
