"""
Juggler checks builder for Janitor.

"""

from infra.reconf_juggler.builders import DeclaredChecksBuilder

j_meta = {
    'urls': [
        {
            'title': 'Arcadia',
            'url': 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/janitor',
            'type': 'arcadia'
        },
        {
            'title': 'Scheduler',
            'url': 'https://sandbox.yandex-team.ru/scheduler/17558/view',
            'type': 'sandbox'
        }
    ]
}


class Builder(DeclaredChecksBuilder):
    default_check_class = 'infra.rtc.juggler.reconf.checks.janitor.Janitor'

    def build_initial_tree(self, initial_data):
        return {
            'rtc_janitor:status': {
                'meta': j_meta,
                'children': {
                    'rtc_janitor:scenarios_notstart': {
                        'meta': j_meta,
                        'children': {
                            'rtc-janitor-sandbox:scenarios_notstart': {
                                'meta': j_meta
                            },
                        },
                    },
                    'rtc_janitor:scenarios_poweroff_queued': {
                        'meta': j_meta,
                        'children': {
                            'rtc-janitor-sandbox:scenarios_poweroff_queued': {
                                'meta': j_meta
                            },
                        },
                    },
                    'rtc_janitor:tickets_errors': {
                        'meta': j_meta,
                        'children': {
                            'rtc-janitor-sandbox:tickets_errors': {
                                'meta': j_meta
                            },
                        },
                    },
                    'rtc_janitor:scenarios_errors': {
                        'meta': j_meta,
                        'children': {
                            'rtc-janitor-sandbox:scenarios_errors': {
                                'meta': j_meta
                            },
                        },
                    },
                }
            }
        }


def main():
    Builder().run(app_desc=__doc__)
