"""
Juggler checks builder for jobs.

"""

from infra.reconf_juggler.builders import DeclaredChecksBuilder


class Builder(DeclaredChecksBuilder):
    default_check_class = 'infra.rtc.juggler.reconf.checks.jobs.SreHourlyJob'

    def build_initial_tree(self, initial_data):
        return {
            'rtc_jobs:sandbox': {
                'children': {
                    'find-walle-maintenance:scheduler': {
                        'meta': {
                            'urls': [
                                {
                                    'title': 'Arcadia',
                                    'url': 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/maintenance_finder',
                                    'type': 'arcadia'
                                },
                                {
                                    'title': 'Scheduler',
                                    'url': 'https://sandbox.yandex-team.ru/scheduler/24503/tasks',
                                    'type': 'sandbox'
                                },
                            ]
                        },
                    },
                    'backup-walle-project:scheduler': {
                        'meta': {
                            'urls': [
                                {
                                    'title': 'Arcadia',
                                    'url': 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/walle_validator/projects',
                                    'type': 'arcadia'
                                },
                                {
                                    'title': 'Scheduler',
                                    'url': 'https://sandbox.yandex-team.ru/scheduler/15033/tasks',
                                    'type': 'sandbox'
                                },
                            ]
                        },
                    },
                    'test-walle-project:scheduler': {
                        'meta': {
                            'reconf': {
                                'class': 'infra.rtc.juggler.reconf.checks.jobs.HourlyJob',  # no alerts
                            },
                            'urls': [
                                {
                                    'title': 'Docs',
                                    'url': 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/walle_validator',
                                    'type': 'arcadia'
                                },
                                {
                                    'title': 'Tests',
                                    'url': 'https://ci.yandex-team.ru/tests?path=infra%2Frtc%2Fwalle_validator',
                                    'type': 'arcadia'
                                },
                            ]
                        },
                    },
                    'rtc-update-golovan:scheduler': {
                        # ReConf-Juggler treat aggregate with empty body as
                        # link to existing aggregate defined somewhere else.
                        # That's why wee keep empty meta here.
                        'meta': {},
                    },
                    'reconf_juggler_sync:reconf-rtc': {
                        'meta': {
                            'reconf': {
                                'class': 'infra.rtc.juggler.reconf.checks.jobs.SreHourlyJob',
                            },
                            'urls': [
                                {
                                    'title': 'Docs',
                                    'url': 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/juggler/reconf#deploy',
                                    'type': 'arcadia'
                                },
                                {
                                    'title': 'Scheduler',
                                    'url': 'https://sandbox.yandex-team.ru/scheduler/21336/view',
                                    'type': 'sandbox'
                                },
                            ],
                        },
                    },
                },
            },
        }


def main():
    Builder().run(app_desc=__doc__)
