"""
Juggler checks builder for QLOUD clusters.

"""

from infra.reconf_juggler.builders import JugglerChecksBuilder
from infra.reconf_juggler.trees.locations import Locations

from infra.rtc.juggler.reconf.checksets import QloudCheckSet
from infra.rtc.juggler.reconf.optfactories import RtcOptFactory


class Builder(JugglerChecksBuilder):
    default_loglevel = 'DEBUG'

    def build_initial_data(self, unused):
        reply = self.resolver['walle']['projects'].resolve({
            'tags': ('qloud',),
            'fields': ('id',),
        })

        projects = {}
        for prj in reply:
            projects['WALLE%PROD@prj=' + prj['id']] = None

        return projects

    def build_initial_tree(self, initial_data):
        return Locations(
            {'qloud': {'children': initial_data, 'tags': ['prj_qloud']}},
            resolver=self.resolver,
        )

    def build_checks_tree(self, initial_tree):
        return QloudCheckSet(
            initial_tree,
            opt_factory=RtcOptFactory(),
            resolver=self.resolver,
        )


def main():
    Builder().run(app_desc=__doc__)
