"""
Juggler checks builder for RTC clusters.

"""
from infra.reconf_juggler.builders import JugglerChecksBuilder
from infra.reconf_juggler.trees.locations import Locations

from infra.rtc.juggler.reconf.checksets import GpuCheckSet, RtcCheckSetProd
from infra.rtc.juggler.reconf.optfactories import RtcOptFactory

ENDPOINT_PREFIX = 'WALLE%PROD@prj='
PRJ_STOPLIST = set()


class CheckSet(RtcCheckSetProd):
    branches = RtcCheckSetProd.branches + GpuCheckSet.branches


class Builder(JugglerChecksBuilder):
    def build_initial_data(self, unused):
        for tag in 'yt', 'yp_masters':  # also has own aggregates
            tagged = self.resolver['walle']['projects'].resolve({
                'tags': (tag,),
                'fields': ('id',),
            })
            for prj in tagged:
                PRJ_STOPLIST.add(prj['id'])

        rtc_tagged = self.resolver['walle']['projects'].resolve({
            'tags': ('runtime',),
            'fields': ('id', 'tags'),
        })

        projects = {}
        self.shared = {'walle_tags': {}}

        for prj in rtc_tagged:
            if prj['id'] in PRJ_STOPLIST:
                continue

            projects['WALLE%PROD@prj=' + prj['id']] = None

            self.shared['walle_tags'][prj['id']] = prj['tags']

        return projects

    def build_initial_tree(self, initial_data):
        return Locations(
            {'rtc': {'children': initial_data, 'tags': ['prj_rtc']}},
            resolver=self.resolver,
        )

    def build_checks_tree(self, initial_tree):
        return CheckSet(
            initial_tree,
            opt_factory=RtcOptFactory(),
            resolver=self.resolver,
            shared=self.shared,
        )


def main():
    Builder().run(app_desc=__doc__)
