from infra.reconf_juggler.builders import DeclaredChecksBuilder
from infra.reconf_juggler.opts import aggregators

from infra.rtc.juggler.reconf.checks.infrastructure import AbstractInfrastructureCheck


class RtcPanelCheck(AbstractInfrastructureCheck):
    """
    """
    doc_url = None  # should be defined in declarative builder

    _aggregator = aggregators.LogicOr


class RtcPanelBuilder(DeclaredChecksBuilder):
    default_check_class = 'infra.rtc.juggler.reconf.builders.projects.rtc.panels.RtcPanelCheck'

    def build_initial_tree(self, initial_data, names_map=None, **kwargs):
        panel = {
            'rtc_panel_{geo}:runtime': {
                'children': {
                    # arcadia:infra/rtc/golovan/alerts/templated/hbf_drops
                    'yasm_asearch_hbf_drops_geowide_{geo}_input:asearch_hbf_drops_geowide_{geo}_input': {},
                    'yasm_asearch_hbf_drops_geowide_{geo}_output:asearch_hbf_drops_geowide_{geo}_output': {}
                },
                'tags': ['runtime_panel']
            },
            'rtc_panel_{geo}:qloud': {
                'children': {
                    # arcadia:infra/rtc/golovan/alerts/templated/hbf_drops
                    'yasm_qloud_hbf_drops_geowide_{geo}_input:qloud_hbf_drops_geowide_{geo}_input': {},
                    'yasm_qloud_hbf_drops_geowide_{geo}_output:qloud_hbf_drops_geowide_{geo}_output': {}
                },
                'tags': ['qloud_panel']
            }
        }
        return super().build_initial_tree(panel, names_map=names_map, **kwargs)
