from infra.rtc.juggler.reconf.builders.projects.rtc.panels import RtcPanelBuilder


class Builder(RtcPanelBuilder):

    def build_initial_data(self, unused):
        return ['sas', 'vla', 'man', 'msk']

    def build_initial_tree(self, initial_data):
        tree = {}

        for geo in initial_data:
            subtree = super().build_initial_tree(
                None,  # ignored here
                names_map={'geo': geo}
            )
            tree.update(subtree)  # TODO: check collisions here

        return tree


def main():
    Builder().run(app_desc=__doc__)
