"""
RTC hostman server related checks. HOSTMAN-78

"""
from infra.reconf_juggler.opts.options import OptionsHandler

from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck
from infra.rtc.juggler.reconf.opts import actives, notifications


class AbstractSaltMasterCheck(RtcCheck):
    """
    Base class for all RTC salt masters checks.

    """
    doc_url = None  # meaningless for abstract check
    maintainers = ('nekto0n', 'vaspahomov', 'warwish')

    _notifications = notifications.Hostman

    _unreach_service_classes = (AbstractUnreachCheck,)

    def get_aggr_unreach_mode(self):
        """
        Children's dependency mode.

        For more info see https://st.yandex-team.ru/RUNTIMECLOUD-13768 and
        infra/rtc/juggler/reconf/__init__.py

        """
        return 'skip'


class hostman_server(AbstractSaltMasterCheck):
    """
    Check hostman server serve http requests.

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/hostman_server/README.md'

    _active = actives.hostman_server_http


class hostman_server_emergency_opts(OptionsHandler):
    @staticmethod
    def get_defaults():
        emergency_dir = '/opt/yandex-hm-server/emergency.d/'
        return {
            'check_options': {
                'args': [
                    '--true-message',
                    'emergency dir (HOSTMAN-229, ' + emergency_dir + ') exists',
                    '--true-status',
                    'CRIT',
                    '--false-message',
                    'Ok',
                    '--false-status',
                    'OK',
                    '--exists',
                    emergency_dir,
                ],
            },
        }


class hostman_server_emergency(AbstractSaltMasterCheck):
    """
    Check hostman server is in emergency mode (or prepared to it).

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/hostman_server_emergency/README.md'

    _options = hostman_server_emergency_opts

    @classmethod
    def provides(cls, is_node=True):
        if is_node:
            return super().provides(is_node=is_node)

        return 'is_file'  # raw event
