from infra.rtc.juggler.reconf.checks import infrastructure, network, jobs, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.informal import AbstractInformalCheck
from infra.rtc.juggler.reconf.opts import notifications

from infra.reconf_juggler.opts.options import OptionsHandler


class reboot_scheduler(jobs.HourlyJob):
    """
    Sandbox task executed successfully
    """
    maintainers = ('yandex_mnt_sa_runtime_mondev_6921',)
    doc_url = 'https://wiki.yandex-team.ru/rtcnetdev/Jeksperimentalnyjj-klaster'
    _notifications = notifications.Sysdev


class l3_ssh_check(infrastructure.ssh, network.AbstractNetworkCheck):
    """Check sshd accepting connections through l3, for checking dummy"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/ssh/README.md'
    _unreach_service_classes = ()


class numa_memorybw(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/numa_memorybw/README.md'

    class CustomOptsHandler(OptionsHandler):
        @staticmethod
        def get_defaults():
            return {'check_options': {'env': {'DELAY_SHARE_CHECK_SECONDS': '3600'}}}

    _options = CustomOptsHandler
