"""
Juggler checks builder for YP clusters.
https://st.yandex-team.ru/RUNTIMECLOUD-9256

"""
import re

from infra.reconf_juggler.builders import JugglerChecksBuilder
from infra.reconf_juggler.trees.locations import Locations

from infra.rtc.juggler.reconf.checksets import GpuCheckSet, RtcCheckSetProd
from infra.rtc.juggler.reconf.optfactories import RtcOptFactory

from infra.rtc.juggler.reconf.builders.projects.yt.clusters import (
    GROUP_TAG_PATTERN as YT_GROUP_TAG_PATTERN
)


class CheckSet(RtcCheckSetProd):
    branches = RtcCheckSetProd.branches + GpuCheckSet.branches


class Builder(JugglerChecksBuilder):
    def build_initial_data(self, unused):
        resolved = self.resolver['walle']['projects'].resolve({
            'tags': ('yp',),
            'fields': ('id', 'tags'),
        })

        projects = {}
        self.shared = {'walle_tags': {}}

        for prj in resolved:
            if self.is_valid_yp_project(prj):
                projects['WALLE%PROD@prj=' + prj['id']] = None

                self.shared['walle_tags'][prj['id']] = prj['tags']

        return projects

    def build_initial_tree(self, initial_data):
        return Locations(
            {'yp': {'children': initial_data, 'tags': ['prj_yp']}},
            resolver=self.resolver,
        )

    def build_checks_tree(self, initial_tree):
        return CheckSet(
            initial_tree,
            opt_factory=RtcOptFactory(),
            resolver=self.resolver,
            shared=self.shared,
        )

    def is_valid_yp_project(self, prj):
        # Some projects tagged by 'yp' tag historically covered by another
        # aggregates builers (yp masters, yt clusters)
        for tag in prj['tags']:
            if re.match(YT_GROUP_TAG_PATTERN, tag) is not None:
                return False

            if tag == 'yp_masters':
                return False

        return True


def main():
    Builder().run(app_desc=__doc__)
