"""
Juggler checks builder for YT clusters.

"""

from infra.reconf_juggler.builders import JugglerChecksBuilder
from infra.reconf_juggler.trees import NodeSet

from infra.rtc.juggler.reconf.optfactories import RtcOptFactory
from infra.rtc.juggler.reconf.checksets import YtCheckSet

from infra.rtc.juggler.reconf.builders.projects.yt import clusters


class Builder(JugglerChecksBuilder):
    def build_initial_tree(self, unused):
        groups, walle_tags = clusters.get_groups(self.resolver)
        self.shared = {'walle_tags': walle_tags}

        return NodeSet(
            {'yt': {'children': groups, 'tags': ['prj_yt']}},
        )

    def build_checks_tree(self, initial_tree):
        return YtCheckSet(
            initial_tree,
            opt_factory=RtcOptFactory(),
            resolver=self.resolver,
            shared=self.shared,
        )


def main():
    Builder().run(app_desc=__doc__)
