"""
YT clusters lists.

"""

import re

ENDPOINT_PREFIX = 'WALLE%PROD@prj='
GPU_TAG_PATTERN = re.compile(r'^rtc\.gpu-(.+)$')
GROUP_TAG_PATTERN = re.compile(r'^rtc\.yt_cluster-(.+)(_.+)?$')

LEGACY_GRP2GRP_MAP = {
    'ofd': 'ofd-xdc',
}


def get_groups(resolver):
    projects = resolver['walle']['projects'].resolve({
        'tags': ('yt',),
        'fields': ('id', 'tags'),
    })

    groups = {}
    walle_tags = {}

    for prj in projects:
        # Walle project may have hosts filtered out by Juggler, HOSTMAN-1156
        endpoint = ENDPOINT_PREFIX + prj['id']
        if resolver['juggler']['instances_count'].resolve(endpoint) < 1:
            continue

        group_name = None
        gpu_vendor = None
        walle_tags[prj['id']] = prj['tags']

        for tag in prj['tags']:
            gpu_tag = re.match(GPU_TAG_PATTERN, tag)
            if gpu_tag is not None:
                vendor = gpu_tag.group(1)
                if vendor != 'none':
                    gpu_vendor = vendor

            group_tag = re.match(GROUP_TAG_PATTERN, tag)
            if group_tag is not None:
                group_name = group_tag.group(1)

        if group_name is None:
            # raise RuntimeError("No cluster tag 'yt_*_network' found")
            continue

        tags = []
        if gpu_vendor is not None:
            group_name += '-gpu'
            tags.append('gpu')
            tags.append('gpu_' + gpu_vendor)

        if group_name in LEGACY_GRP2GRP_MAP:
            group_name = LEGACY_GRP2GRP_MAP[group_name]

        groups.setdefault(group_name, {}).setdefault(
            'projects', []).append(prj['id'])

        tags.append('grp_' + group_name)
        groups[group_name]['tags'] = tags

    assert groups, "no groups found"

    for grp in groups.values():
        grp['children'] = {
            'WALLE%PROD@prj=' + x: None for x in grp.pop('projects')}

    return groups, walle_tags
