"""
Juggler panels builder for YT clusters.

"""

from infra.rtc.juggler.reconf.builders.projects.yt import clusters
from infra.rtc.juggler.reconf.builders.projects.yt.panels import YtPanelBuilder

BLACKLISTED_GROUPS = {
    'inbox',  # https://st.yandex-team.ru/HOSTMAN-491#5ef9f913b7113142422f4062
}


class Builder(YtPanelBuilder):
    def build_initial_tree(self, unused):
        tree = {}
        groups, _ = clusters.get_groups(self.resolver)

        for group in groups:
            if group in BLACKLISTED_GROUPS:
                continue

            names_map = {
                'prefix': 'yt_',
                'name': group,
                'suffix': '_panel'
            }
            subtree = super().build_initial_tree(
                {},
                names_map=names_map,
            )
            tree.update(subtree)  # TODO: check collisions here

        return tree


def main():
    Builder().run(app_desc=__doc__)
