"""
Juggler panels builder for Qloud & RTC clusters.

"""

from infra.rtc.juggler.reconf.builders.shared.panels.rtc import RtcPanelBuilder
from infra.rtc.juggler.reconf.checks import (
    cloud,
    hardware,
    hostman,
    informal,
    infrastructure,
    unispace,
    unreachable,
)


runtime_panel = {
    'panel_users': {
        'sre': {
            'cluster_panel_suffix': '_sre',
            'tag_suffix': '_panel_sre'
        },
        'duty': {
            'cluster_panel_suffix': '_duty',
            'tag_suffix': '_panel_duty'
        }
    },
    'clusters': (
        {
            'cluster_agg_name': 'rtc_sas',
            'panel_agg_name':   'runtime_sas',
            'geo':              'sas'
        },
        {
            'cluster_agg_name': 'rtc_vla',
            'panel_agg_name':   'runtime_vla',
            'geo':              'vla'
        },
        {
            'cluster_agg_name': 'rtc_man',
            'panel_agg_name':   'runtime_man',
            'geo':              'man'
        },
        {
            'cluster_agg_name': 'rtc_msk',
            'panel_agg_name':   'runtime_msk',
            'geo':              ('iva', 'myt')
        },
    ),
    'tags': {
        'cluster': 'runtime_clusters',
        'route_suffix': '_routes'
    },
    'two_layers': True,
    'routes': (
        {
            'name': 'unreachable',
            'metrics': (
                unreachable.UNREACHABLE,
            )
        },
        {
            'name': 'infrastructure',
            'metrics': (
                hardware.walle_tainted_kernel,
                unispace.fs_free_space_syst,
                # Selective target metrics
                {
                    'users': ('sre', ),
                    'metrics': (
                        # 'kernel_version',
                        hardware.walle_fs_check,
                        infrastructure.ssh,
                        cloud.skynet_copier,
                        informal.grub2_check,
                        informal.skybone_locked_mem,
                        cloud.certman,
                        informal.walle_reboots,
                        infrastructure.check_dstate_count,
                        infrastructure.cron,
                        infrastructure.ntp,
                        infrastructure.fs_mount_opts,
                        infrastructure.rotmissingdocs,
                        cloud.check_skynet_procs,
                        infrastructure.bind,
                        hostman.hostman_salt,
                        cloud.check_iss_agent,
                        cloud.portod_tasks,
                        informal.fs_free_space_user,
                        informal.fs_free_space_serv
                    )
                },
            )
        },
        {
            'name': 'hardware',
            'metrics': (
                hardware.walle_cpu,
                # Selective target metrics
                {
                    'users': ('sre', ),
                    'metrics': (
                        informal.ssd_link,
                        hardware.walle_disk,
                        hardware.walle_memory,
                    )
                }
            )
        },
        {
            'name': 'performance',
            'metrics': (
                {
                    'users': ('sre', ),
                    'metrics': (
                        hardware.cpu_throt_capping_check,
                        hardware.cpu_throt_check,
                        hardware.cpu_throt_frequency_check,
                        hardware.cpu_throt_perf_check,
                        hardware.cpu_throt_thermal_check,
                        hardware.cpu_throt_turboboost_check,
                        hardware.walle_cpu
                    )
                },
            )
        },
        {
            'name': 'network',
            'metrics': (
                {
                    # Possible types:
                    #   - external (requires a per-DC map of required children of metrics)
                    #   - external-per-geo (requires a list of required children of metrics as strings
                    #                       with a {geo} placeholder for geo substitution). Multiple DCs (geos) can be
                    #                       used for a single cluster
                    'type': 'external-per-geo',
                    'clusters-avoid': ('rtc_msk', ),
                    # Produces a Cartesian product of each metric and location (if geo field presents in a cluster
                    # definition)
                    'metrics': (
                        # Tuple full name->short name
                        (
                            'hbf.drops.hcount.{geo}:hbf_drops_asearch_hostcount_geowide_{geo}_input',
                            'hbf_drops_input',
                        ),
                        (
                            'hbf.drops.hcount.{geo}:hbf_drops_asearch_hostcount_geowide_{geo}_output',
                            'hbf_drops_output',
                        )
                    )
                },
                {
                    'type': 'external',
                    'clusters': ('rtc_msk', ),
                    'metrics': {
                        'rtc_msk': (
                            # Tuple full name->short name
                            (
                                'hbf.drops.hcount.msk:hbf_drops_asearch_hostcount_geowide_msk_input',
                                'hbf_drops_input',
                            ),
                            (
                                'hbf.drops.hcount.msk:hbf_drops_asearch_hostcount_geowide_msk_output',
                                'hbf_drops_output',
                            )
                        ),
                    }
                },
            )
        },
    )
}

rtc_all_panel = {
    'panel_users': {
        'sre': {
            'cluster_panel_suffix': '_sre',
            'tag_suffix': '_panel_sre'
        },
        'duty': {
            'cluster_panel_suffix': '_duty',
            'tag_suffix': '_panel_duty'
        }
    },
    'clusters': ('rtc_all', ),
    'tags': {
        'cluster': 'runtime_clusters',
        'route_suffix': '_routes'
    },
    'two_layers': True,
    'routes': (
        {
            'name': 'network',
            'metrics': (
                {
                    'type': 'external',
                    # This is per-DC map of required children
                    'metrics': {
                        'rtc_all': (
                            # Tuple full name->short name
                            ('yasm_hbf-apply-rules-orly:hbf-apply-rules-orly', 'hbf_rules_orly',),
                        ),
                    }
                },
            )
        },
    )
}

qloud_panel = {
    'panel_users': {
        'sre': {
            'cluster_panel_suffix': '_sre',
            'tag_suffix': '_panel_sre'
        },
        'duty': {
            'cluster_panel_suffix': '_duty',
            'tag_suffix': '_panel_duty'
        }
    },
    'clusters': (
        {
            'cluster_agg_name': 'qloud_sas',
            'geo':              'sas'
        },
        {
            'cluster_agg_name': 'qloud_vla',
            'geo':              'vla'
        },
        {
            'cluster_agg_name': 'qloud_man',
            'geo':              'man'
        },
        {
            'cluster_agg_name': 'qloud_msk',
            'geo':              'msk'
        },
    ),
    'tags': {
        'cluster': 'qloud_clusters',
        'route_suffix': '_routes'
    },
    'two_layers': True,
    'routes': (
        {
            'name': 'unreachable',
            'metrics': (
                unreachable.UNREACHABLE,
            )
        },
        {
            'name': 'infrastructure',
            'metrics': (
                hardware.walle_tainted_kernel,
                unispace.fs_free_space_syst,
                # Selective target metrics
                {
                    'users': ('sre', ),
                    'metrics': (
                        # 'kernel_version',
                        hardware.walle_fs_check,
                        infrastructure.ssh,
                        cloud.skynet_copier,
                        informal.grub2_check,
                        informal.skybone_locked_mem,
                        cloud.certman,
                        informal.walle_reboots,
                        infrastructure.check_dstate_count,
                        infrastructure.cron,
                        infrastructure.ntp,
                        infrastructure.fs_mount_opts,
                        infrastructure.rotmissingdocs,
                        cloud.check_skynet_procs,
                        infrastructure.bind,
                        hostman.hostman_salt,
                        cloud.check_iss_agent,
                        cloud.portod_tasks,
                        informal.fs_free_space_user,
                        informal.fs_free_space_serv
                    )
                },
            )
        },
        {
            'name': 'hardware',
            'metrics': (
                hardware.walle_cpu,
                # Selective target metrics
                {
                    'users': ('sre', ),
                    'metrics': (
                        informal.ssd_link,
                        hardware.walle_disk,
                        hardware.walle_memory,
                    )
                }
            )
        },
        {
            'name': 'performance',
            'metrics': (
                {
                    'users': ('sre', ),
                    'metrics': (
                        hardware.cpu_throt_capping_check,
                        hardware.cpu_throt_check,
                        hardware.cpu_throt_frequency_check,
                        hardware.cpu_throt_perf_check,
                        hardware.cpu_throt_thermal_check,
                        hardware.cpu_throt_turboboost_check,
                        hardware.walle_cpu
                    )
                },
            )
        },
        {
            'name': 'network',
            'metrics': (
                {
                    'type': 'external-per-geo',
                    # Produces a Cartesian product of each metric and location (if geo field presents in a cluster
                    # definition)
                    'metrics': (
                        # Tuple full name->short name
                        (
                            'hbf.drops.hcount.{geo}:hbf_drops_asearch_hostcount_geowide_{geo}_input',
                            'hbf_drops_input',
                        ),
                        (
                            'hbf.drops.hcount.{geo}:hbf_drops_asearch_hostcount_geowide_{geo}_output',
                            'hbf_drops_output',
                        ),
                    )
                },
            )
        },
    )
}


class Builder(RtcPanelBuilder):
    def build_initial_tree(self, initial_data, **kwargs):
        tree = super(Builder, self).build_initial_tree(
            None,
            panel_definition=runtime_panel,
            names_map={'global_panel': 'rtc_overall',
                       'global_lamp': 'rtc',
                       'cluster_panel': 'rtc_lamps',
                       'route_panel_suffix': '_routes'
                       }
        )

        tree.update(super(Builder, self).build_initial_tree(
            None,
            panel_definition=rtc_all_panel,
            names_map={'global_panel': 'rtc_overall',
                       'global_lamp': 'rtc',
                       'cluster_panel': 'rtc_lamps',
                       'route_panel_suffix': '_routes'
                       }
        ))

        tree.update(super(Builder, self).build_initial_tree(
            None,
            panel_definition=qloud_panel,
            names_map={'global_panel': 'rtc_overall',
                       'global_lamp': 'qloud',
                       'cluster_panel': 'qloud_lamps',
                       'route_panel_suffix': '_routes'
                       }
        ))

        return tree


def main():
    Builder().run(app_desc=__doc__)


if __name__ == '__main__':
    main()
