from infra.reconf_juggler import Check

from infra.rtc.juggler.reconf.opts import (
    aggregators,
    flaps,
    namespaces,
    notifications,
)


ARCADIA_HTTP_URL = 'https://a.yandex-team.ru/arc/trunk/arcadia'
RTC_BUNDLE_HTTP_URL = ARCADIA_HTTP_URL + '/infra/rtc/juggler/bundle'


class RtcCheck(Check):
    """
    Base class for RTC checks.

    """
    _aggregator = aggregators.Production
    _flap = flaps.Production
    _namespace = namespaces.RTC
    _notifications = notifications.Production

    _unreach_service_hold = 600

    category = 'misc'
    doc_url = None  # meaningless for abstract check
    maintainers = ('yandex_mnt_sa_runtime_cross',)

    # every check class definition MUST have it's own (parent's attr ignored)
    # doc_url attribute, ValidationError will be raised otherwise.
    validate_class_doc_url = True

    def get_aggr_unreach_mode(self):
        """
        Children's dependency mode.
        https://wiki.yandex-team.ru/sm/juggler/aggregation-modules/#zavisimostimezhduproverkami

        While 'skip' gives more accurate aggregate status it seems this not
        suitable to infrastructure checks - no matter alive cron or not when
        host is dead.

        In other words:
        * `force_ok` is better for infrastructure (intermediate) checks.
        * `skip` is better for user services checks. It's nice to have alert
          that your service has one replica instead of three just because other
          two are UNREACHABLE.

        """
        return 'force_ok'
