from infra.reconf_juggler.opts.options import OptionsHandler

from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck
from infra.rtc.juggler.reconf.opts import notifications, ttls


class AbstractCloudCheck(RtcCheck):
    """
    Base class for all RTC cloud related checks.

    """
    category = 'cloud'
    doc_url = None  # meaningless for abstract check

    _unreach_service_classes = (AbstractUnreachCheck,)


class certman(AbstractCloudCheck):
    """Check host certificate status."""

    doc_url = 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/certman/README.md#monitoring'

    _notifications = notifications.HostmanSensitive


class check_iss_agent(AbstractCloudCheck):
    """
    Check ISS agent status

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_iss_agent/README.md'
    maintainers = ('yandex_search_tech_searchinfradev_skynet',)


class check_skynet_procs(AbstractCloudCheck):
    """
    Check status for skynet processes (rely on skynet self-check)

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_skynet_procs/README.md'
    maintainers = ('yandex_search_tech_searchinfradev_skynet',)

    _notifications = notifications.Nanny


class portod_tasks(AbstractCloudCheck):
    """
    Check portod tasks

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/portod_tasks/README.md'
    _notifications = notifications.Sysdev
    maintainers = ('yandex_mnt_sa_runtime_mondev_6921',)


class skynet_copier(AbstractCloudCheck):
    """
    Try to share and fetch files using skynet copier
    https://st.yandex-team.ru/SEPE-8119

    """
    class CustomOptsHandler(OptionsHandler):
        @staticmethod
        def get_defaults():
            return {'check_options': {'env': {'DELAY_SHARE_CHECK_SECONDS': '3600'}}}

    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/skynet_copier/README.md'
    maintainers = ('yandex_search_tech_searchinfradev_skynet',)
    _options = CustomOptsHandler
    _ttl = ttls.FortyFiveMinutes
