from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck
from infra.rtc.juggler.reconf.opts import aggregators, flaps, notifications


class AbstractHardwareCheck(RtcCheck):
    """
    Base class for all RTC hardware checks.

    """
    category = 'hardware'
    doc_url = None  # meaningless for abstract check

    _unreach_service_classes = (AbstractUnreachCheck,)


class bad_raid_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/bad_raid_check/README.md'


class cpu_throt_capping_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_throt_capping_check/README.md'


class cpu_throt_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_throt_check/README.md'


class cpu_throt_frequency_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_throt_frequency_check/README.md'


class cpu_throt_perf_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_throt_perf_check/README.md'


class cpu_throt_thermal_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_throt_thermal_check/README.md'

    _flap = flaps.Disabled  # it's better to see this crits ASAP


class cpu_throt_turboboost_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_throt_turboboost_check/README.md'


class gpumanager(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/gpumanager/README.md'

    _notifications = notifications.Sysdev


class link_utilization(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/link_utilization/README.md'

    _aggregator = aggregators.Relaxed
    _flap = flaps.Relaxed


class walle_bmc(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_bmc/README.md'


class walle_cpu(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_cpu/README.md'


class walle_disk(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_disk/README.md'


class walle_fs_check(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_fs_check/README.md'


class walle_link(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_link/README.md'


class walle_memory(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_memory/README.md'


class walle_tainted_kernel(AbstractHardwareCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_tainted_kernel/README.md'
