from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck
from infra.rtc.juggler.reconf.opts import aggregators, ttls, notifications


class AbstractInformalCheck(RtcCheck):
    """
    Base class for all RTC informal checks

    """
    category = 'informal'
    doc_url = None  # meaningless for abstract check

    _aggregator = aggregators.Informal
    _unreach_service_classes = (AbstractUnreachCheck,)


class check_atop(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_atop/README.md'

    _ttl = ttls.ThreeHours


class check_cpu(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_cpu/README.md'


class cpu_state(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cpu_state/README.md'


class fs_free_space_user(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/fs_free_space_user/README.md'


class fs_free_space_serv(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/fs_free_space_serv/README.md'


class grub2_check(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/grub2_check/README.md'

    _ttl = ttls.ThreeHours


class io_monitor(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/io_monitor/README.md'


class load_monitor(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/load_monitor/README.md'


class eth_errors(AbstractInformalCheck):
    """
    Check that there is no errors in ethtool output

    https://st.yandex-team.ru/HWPROBLEMS-43

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/eth_errors/README.md'
    _notifications = notifications.Sysdev
    maintainers = ('yandex_mnt_sa_runtime_mondev_6921',)


class need_reboot_kernel(AbstractInformalCheck):
    """
    Check current kernel version

    Raw events managed by salt directly (absent in bundle)
    https://st.yandex-team.ru/RUNTIMECLOUD-9305

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/need_reboot_kernel/README.md'


class net_errors(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/net_errors/README.md'


class numa_memory(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/numa_memory/README.md'


class raid_state(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/raid_state/README.md'


class skybone_locked_mem(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/skybone_locked_mem/README.md'


class ssd_link(AbstractInformalCheck):
    """Ensure SSD disks connected to fast SATA links"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/ssd_link/README.md'

    _ttl = ttls.ThreeHours


class walle_reboots(AbstractInformalCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/walle_reboots/README.md'
