import infra.reconf_juggler.opts.actives

from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL, ARCADIA_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck

from infra.rtc.juggler.reconf.opts import (
    notifications,
    ttls
)


class AbstractInfrastructureCheck(RtcCheck):
    """
    Base class for all RTC infrastructure checks.

    """
    category = 'infra'
    doc_url = None  # meaningless for abstract check

    _unreach_service_classes = (AbstractUnreachCheck,)


class bind(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/bind/README.md'

    _notifications = notifications.Sysdev


class check_dstate_count(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_dstate_count/README.md'


class cron(AbstractInfrastructureCheck):
    """
    Check cron daemon is up and running

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cron/README.md'

    _notifications = notifications.Sre


class cron_errs(AbstractInfrastructureCheck):
    """
    Check cron daemon errors reports

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/cron_errs/README.md'


class fs_mount_opts(AbstractInfrastructureCheck):
    """Ensure main filesystems are mounted with proper opts."""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/fs_mount_opts/README.md'

    _ttl = ttls.ThreeHours


class ntp(AbstractInfrastructureCheck):
    """Check ntpd and clock sync status."""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/ntp/README.md'

    _notifications = notifications.Sre


class packages_state(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/packages_state/README.md'


class sysconf(AbstractInfrastructureCheck):
    """
    Checking that sysconf cron job works properly
    """
    doc_url = ARCADIA_HTTP_URL + '/infra/rsm/sysconf/README.md'

    _notifications = notifications.Sysdev


class cauth_userd(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/cauth/agent/linux/juggler/bundle'

    _notifications = notifications.Sre


class nvidia_containers(AbstractInfrastructureCheck):
    """
    RUNTIMECLOUD-8975
    This check tests what all NVidia dev files passed into porto container
    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/nvidia_containers/README.md'

    _notifications = notifications.Sre


class rotmissingdocs(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/rotmissingdocs/README.md'


class dns64_localcacher(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/dns64_localcacher/README.md'


class qloud_logoped(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/qloud_logoped/README.md'


class qloud_logoped_statforward(AbstractInfrastructureCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/qloud_logoped_statforward/README.md'


class ssh(AbstractInfrastructureCheck):
    """Check sshd accepting connections"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/ssh/README.md'

    _active = infra.reconf_juggler.opts.actives.ssh
    _notifications = notifications.Sre
