from infra.reconf_juggler.opts import aggregators

from infra.rtc.juggler.reconf.checks import RtcCheck
from infra.rtc.juggler.reconf.opts import flaps, notifications, ttls


class AbstractJanitorCheck(RtcCheck):
    """
    Base class for Janitor checks.

    """
    category = 'janitor'
    doc_url = None  # meaningless for abstract check

    _aggregator = aggregators.LogicOr
    _notifications = notifications.WalleSensitiveTg


class Janitor(AbstractJanitorCheck):
    """
    Juggler executing events.

    Juggler emit events for this check type while scheduled execution

    """
    doc_url = None  # defined in declarative builders

    _flap = flaps.Disabled  # ttl is too high
    _ttl = ttls.ThreeHours
