from infra.reconf_juggler.opts import aggregators

from infra.rtc.juggler.reconf.checks import RtcCheck
from infra.rtc.juggler.reconf.opts import flaps, notifications, ttls


class AbstractJobCheck(RtcCheck):
    """
    Base class for job checks.

    Ensure job executed successfully.
    Usually job emits raw events by itself, for example see
    https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/walle/BackupWalleProjects/__init__.py?rev=5794628#L47

    """
    category = 'jobs'
    doc_url = None  # meaningless for abstract check

    _aggregator = aggregators.LogicOr


class HourlyJob(AbstractJobCheck):
    """ Ensure job completed at least three hours ago. """
    doc_url = None  # reusable, defined in declarative builders

    _flap = flaps.Disabled  # ttl is too high
    _ttl = ttls.ThreeHours


class SreHourlyJob(HourlyJob):
    """ Hourly job check with alerts to SRE RTC. """
    doc_url = None  # reusable, defined in declarative builders

    _notifications = notifications.Sre
