from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import UNREACHABLE
from infra.rtc.juggler.reconf.checks.infrastructure import ssh
import infra.rtc.juggler.reconf.opts.actives


class AbstractMonitoringCheck(RtcCheck):
    """
    Base class for all RTC monitoring specific checks.

    """
    category = 'monitoring'
    doc_url = None  # meaningless for abstract check

    _unreach_service_classes = (UNREACHABLE, ssh)


class yasmagent_ping(AbstractMonitoringCheck):
    """yasmagent availability. GOLOVAN-6819"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/yasmagent_ping/README.md'

    _active = infra.rtc.juggler.reconf.opts.actives.yasmagent_http
