from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck
from infra.rtc.juggler.reconf.opts import notifications, ttls


class AbstractNetworkCheck(RtcCheck):
    """
    Base class for all RTC network checks.

    """
    category = 'network'
    doc_url = None  # meaningless for abstract check

    _unreach_service_classes = (AbstractUnreachCheck,)
    _notifications = notifications.Sysdev
    maintainers = ('yandex_mnt_sa_runtime_mondev_6921',)


class abnormal_ip_conf(AbstractNetworkCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/abnormal_ip_conf/README.md'


class check_ra(AbstractNetworkCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_ra/README.md'
    _ttl = ttls.HalfAnHour


class fastbone(AbstractNetworkCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/fastbone/README.md'


class fb_route_check(AbstractNetworkCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/fb_route_check/README.md'


class hbf_agent_rtc(AbstractNetworkCheck):
    """Check hbf agent is running"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/hbf_agent_rtc/README.md'


class hbf_rules_validation(AbstractNetworkCheck):
    """Check hbf rules validation passed"""
    doc_url = 'https://st.yandex-team.ru/RTCNETWORK-457'
    _ttl = ttls.FourHours
    _notifications = notifications.SysdevNoc

    @classmethod
    def provides(cls, is_node=True):
        if is_node:
            return super().provides(is_node=is_node)
        return 'hbf-rules-validation'  # raw event with dashes


class tcp_sampler_dump(AbstractNetworkCheck):
    """Check tcp sampler dumps"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/tcp_sampler_dump/README.md'


class ip_groups(AbstractNetworkCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/ip_groups/README.md'


class net_irq(AbstractNetworkCheck):
    """
    Check network IRQ affinity.

    """
    # TODO: fix docs string and remove `provides` method when check become
    # native (statically built) in bundle

    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/check_network_irq/README.md'

    @classmethod
    def provides(cls, is_node=True):
        if is_node:
            return super().provides(is_node=is_node)
        return 'check_network_irq'  # raw event


class tsolro_check(AbstractNetworkCheck):
    """FIXME: docs required (RUNTIMECLOUD-9527)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/tsolro_check/README.md'

    _ttl = ttls.ThreeHours


class ll_duplicate_addr(AbstractNetworkCheck):
    """Check that ifaces has no duplicate address (RTCNETWORK-276)"""
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/ll_duplicate_addr/README.md'
