from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.checks.unreachable import AbstractUnreachCheck
from infra.rtc.juggler.reconf.opts import notifications


class AbstractUnispaceCheck(RtcCheck):
    """
    Base class for all RTC fs space checks.

    """
    category = 'unispace'
    doc_url = None  # meaningless for abstract check

    _unreach_service_classes = (AbstractUnreachCheck,)


class fs_free_space_syst(AbstractUnispaceCheck):
    """
    Check free space on root file system

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/fs_free_space_syst/README.md'

    _notifications = notifications.Sre
