import infra.reconf_juggler.opts.actives

from infra.rtc.juggler.reconf.checks import RtcCheck, RTC_BUNDLE_HTTP_URL
from infra.rtc.juggler.reconf.opts import (
    flaps,
    notifications,
    refresh_times,
    ttls,
)


class AbstractUnreachCheck(RtcCheck):
    """
    Base class for RTC unreachable checks.

    """
    category = 'unreach'
    doc_url = None  # meaningless for abstract check


class UNREACHABLE(AbstractUnreachCheck):
    """
    Check host network availability (ping from juggler servers)

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/UNREACHABLE/README.md'

    _active = infra.reconf_juggler.opts.actives.UNREACHABLE
    _flap = flaps.Disabled  # already has builtin one, HOSTMAN-443
    _notifications = notifications.Sre
    _refresh_time = refresh_times.RefreshTimeOneMinute
    _ttl = ttls.TenMinutes


class META(AbstractUnreachCheck):
    """
    Legacy, will be removed in https://st.yandex-team.ru/RUNTIMECLOUD-9786

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/META/README.md'

    _unreach_service_classes = (UNREACHABLE,)


class bundle_info(AbstractUnreachCheck):
    """
    Checks bundle version control check

    Show bundle name and version. Unable to emit any status except OK. NO DATA
    means juggler agent is dead or have no resources to run checks.

    """
    doc_url = RTC_BUNDLE_HTTP_URL + '/checks/bundle_info/README.md'

    _unreach_service_classes = (UNREACHABLE,)
    _notifications = notifications.Sre
