"""
Wall-e hosts status checks.
See details in https://st.yandex-team.ru/WALLE-3766

"""

from infra.rtc.juggler.reconf.checks.hardware import AbstractHardwareCheck
from infra.rtc.juggler.reconf.opts import flaps, ttls


class AbstractWalleStatusCheck(AbstractHardwareCheck):
    """ Base class for all Wall-e host status checks. """
    doc_url = None  # meaningless for abstract check

    _flap = flaps.Disabled  # ttl is too high
    _ttl = ttls.HalfAnHour


class walle_status(AbstractWalleStatusCheck):
    """
    Check wall-e status for host.

    OK - host is ready for production use.
    WARN - host is moving from OK to CRIT (waiting for CMS, for example).
    CRIT - host is not suitable for production use.

    """
    doc_url = 'https://st.yandex-team.ru/WALLE-3801'
