import logging

from infra.reconf import ConfOptDenied, NodesHandler
from infra.reconf_juggler import CheckOptFactory

from infra.rtc.juggler.reconf.checks.hardware import gpumanager
from infra.rtc.juggler.reconf.checksets import GpuCheckSet


class NodesFilter(NodesHandler):
    def get_handled_value(self, key, val):
        if self.is_apropriate_node(key, val):
            return super().get_handled_value(key, val)

        raise ConfOptDenied

    def is_apropriate_node(self, key, val):
        if val is None:
            return self.is_apropriate_endpoint(key)

        if val.has_endpoints() or val.has_subnodes():
            return True
        else:
            logging.debug('Aggregate is empty ' + key)

        return False

    def is_apropriate_endpoint(self, key):
        if key.startswith('WALLE%PROD@prj='):
            # A bit dirty now, will be fixed when endpoints become objects
            # with proper attributes
            walle_prj = key.replace('WALLE%PROD@prj=', '').split(
                ':', 1)[0].split('&', 1)[0]

            try:
                walle_tags = self._bound.shared['walle_tags'][walle_prj]
            except KeyError:
                return True

            check_class = self._bound._bound.__class__

            if check_class is gpumanager and 'rtc.gpu-vfio' in walle_tags:
                return True

            if check_class in GpuCheckSet.branches:
                if 'rtc.gpu-nvidia' not in walle_tags:
                    logging.debug('Inapropriate endpoint (project has no '
                                  'rtc.gpu-nvidia tag) ' + key)
                    return False

        return True


class RtcOptFactory(CheckOptFactory):
    """
    Shared opt factory for RTC checks.

    """
    def create_handler(self, handler_class, check):
        if issubclass(handler_class, NodesHandler):
            return super().create_handler(NodesFilter, check)

        return super().create_handler(handler_class, check)
