"""
Collection of RTC Juggler active opts.

"""

from infra.reconf_juggler.opts.actives import ActiveHandler


class hostman_server_http(ActiveHandler):
    """
    Check hostman server serve http requests.

    """
    def get_default_value(self, key):
        if key == 'active':
            return 'http'

        elif key == 'active_kwargs':
            return {
                'always_show_body': False,
                'disable_ipv4': True,
                'ok_codes': [
                    200,
                ],
                'path': '/unistat',
                'port': 8080,
            }

        return super().get_default_value(key)


class yasmagent_http(ActiveHandler):
    """
    Host yasmagent http check.

    """
    def get_default_value(self, key):
        if key == 'active':
            return 'http'

        elif key == 'active_kwargs':
            return {
                'always_show_body': True,
                'disable_ipv4': True,
                'ok_codes': [
                    200,
                ],
                'path': '/version',
                'port': 11003,
            }

        return super().get_default_value(key)
