"""
Flap detectors (suppressors) for RTC Juggler checks.

https://wiki.yandex-team.ru/sm/juggler/FlapDetector/#podavlenieflapov

"""

from infra.reconf_juggler.opts.flaps import FlapHandler


class Disabled(FlapHandler):
    """
    Disabled flap detector.

    IMPORTANT:
    To disable flap detector, all values should be explicitly set to None
    (inherited). Values absence is simply ignored by juggler sdk or api.
    See https://st.yandex-team.ru/RUNTIMECLOUD-14267#5d67fc3029af1d001d2e8af1

    """


class Production(FlapHandler):
    """
    Default production flap detector.

    """
    @staticmethod
    def get_defaults():
        # TODO: borrowed from JTT, should be revised
        return {
            'flaps': {
                'boost': 0,
                'critical': 1200,
                'stable': 600,
            }
        }


class Relaxed(FlapHandler):
    """
    Relaxed flap detector.

    """
    @staticmethod
    def get_defaults():
        # TODO: borrowed from JTT, should be revised
        return {
            'flaps': {
                'boost': 0,
                'critical': 1800,
                'stable': 900,
            }
        }
